/*:
 * @target MZ
 * @plugindesc ゲーム起動時にimg/pictures内のPNG画像だけをキャッシュにロードします。
 * @author ChatGPT
 *
 * @help
 * このプラグインはゲーム起動時にimg/picturesフォルダ内の
 * 拡張子 .png の画像のみをImageManagerで読み込みキャッシュに保持します。
 *
 * 利用条件:
 * 商用・非商用問わず利用可／クレジット表記不要
 */

(() => {
    const fs = require("fs");
    const path = require("path");

    const preloadPngPictures = () => {
        const picturesPath = path.join("img", "pictures");
        if (fs.existsSync(picturesPath)) {
            const files = fs.readdirSync(picturesPath);
            files.forEach(file => {
                if (file.toLowerCase().endsWith(".png")) {
                    const name = path.basename(file, ".png");
                    ImageManager.loadPicture(name);
                    console.log(`[PreloadPngPictures] Loaded: ${name}`);
                }
            });
        }
    };

    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function () {
        preloadPngPictures();
        _Scene_Boot_start.call(this);
    };
})();